package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.NestableComment;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.json.CommentReplyView;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import com.ibm.icu.text.SimpleDateFormat;

public class TestCommentReplyViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		CommentReplyViewBuilder builder = new CommentReplyViewBuilder();
		
		try {
			builder.build(null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		NestableComment nc = new NestableComment();
		nc.setId(1);
		nc.setActivityId(2);
		nc.setRequestId(3);
		nc.setCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		nc.setText("short text");
		nc.setDescription("description");
		
		CommentReplyView crv = builder.build(nc);
		Assert.assertNotNull(crv);
		Assert.assertEquals(crv.getReplyId(), 1);
		Assert.assertEquals(crv.getActivityId(), 2);
		Assert.assertEquals(crv.getRequestId(), 3);
		Assert.assertEquals(crv.getShortText(), "short text");
		Assert.assertNotNull(crv.getCreated());
		Assert.assertEquals(crv.getDescription(), "description");
		
		// verify that the date is formatted MM/dd/yyyy
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
		java.util.Date date = sdf.parse(crv.getCreated());
		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(date);
		
		//commented out this test, because we cannot guarantee that this test will only be run during 2013
		//Assert.assertEquals(gc.get(Calendar.YEAR), 2013);
		GregorianCalendar currCalendar = new GregorianCalendar();
		Assert.assertEquals(gc.get(Calendar.YEAR), currCalendar.get(Calendar.YEAR));
		
		// test trimming of the short text
		nc.setText("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
		crv = builder.build(nc);
		Assert.assertNotNull(crv);
		Assert.assertEquals(crv.getShortText(), "1234567890123456789012345678901234567890");
		Assert.assertEquals(crv.getCommentText(), "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
		
	}
	
}
